PROC TABULATE DATA=ghpb16 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ENT2 filingsize / PRELOADFMT; 
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2016';
title3 'All Plans';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb16 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ENT2 filingsize / PRELOADFMT; 
where filingsize='1';
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2016';
title3 'Plans with 100 or More Participants & Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb16 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ENT2 filingsize / PRELOADFMT; 
where filingsize='2';
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2016';
title3 'Plans with 100 or More Participants & No Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb16 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ENT2 filingsize / PRELOADFMT; 
where filingsize='3';
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2016';
title3 'Plans with Fewer Than 100 Participants & Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  
